<?php
/* --------------------------------------------------------------
  StoredBoilerplateConfig.inc.php 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

namespace StyleEdit\Entities;

/**
 * Class StoredBoilerplateConfig
 *
 * @package StyleEdit\Entities
 */
class StoredBoilerplateConfig extends StoredConfig
{
	/**
	 * Returns the thumbnail as a relative filepath
	 *
	 * @return string
	 */
	public function getThumbnail()
	{
		return $this->jsonData['thumbnail'];
	}
	
	
	/**
	 * Disallow changing the filename for boilerplates.
	 *
	 * @param $p_filename
	 *
	 * @return \StyleEdit\Entities\StoredBoilerplateConfig Same instance to make chained method calls possible.
	 */
	public function setFilename($p_filename)
	{
		return $this;
	}
}